import { combineReducers } from 'redux';
import * as t from './actionTypes';

const templates = (state = {}, action) => {
  switch (action.type) {
    case t.TEMPLATES_RESET:
      return {};

    case t.TEMPLATES_LIST + '_REQUEST':
      return {
        ...state,
        isFetch: true,
      };
    case t.TEMPLATES_LIST + '_RECIEVE':
      return {
        ...state,
        data: action.data,
        isLoad: true,
        isFetch: false,
        isError: false,
      };
    case t.TEMPLATES_LIST + '_FAIL':
      return {
        ...state,
        isFetch: false,
        isError: true,
      };
    default:
      return state;
  }
}

const template = (state = {}, action) => {
  switch (action.type) {
    case t.TEMPLATE_RESET:
      return {};

    case t.TEMPLATE_ADD:
      return {
        ...state,
        data: {},
        isNew: true,
        isEdit: false,
        isSave: false,
        isDelete: false,
        isReset: false,
      };

    case t.TEMPLATE_EDIT + '_REQUEST':
      return {
        ...state,
        isFetch: true,
        isNew: false,
      };
    case t.TEMPLATE_EDIT + '_RECIEVE':
      return {
        ...state,
        data: action.data,
        isLoad: true,
        isFetch: false,
        isNew: false,
        isEdit: true,
        isSave: false,
        isDelete: false,
        isReset: false,
        isError: false,
      };
    case t.TEMPLATE_EDIT + '_FAIL':
      return {
        ...state,
        isFetch: false,
        isEdit: false,
        isError: true,
      };

    case t.TEMPLATE_SAVE + '_REQUEST':
      return {
        ...state,
        isFetch: true,
      };
    case t.TEMPLATE_SAVE + '_RECIEVE':
      return {
        ...state,
        data: action.args,
        responce: action.data,
        isFetch: false,
        isNew: false,
        isEdit: false,
        isSave: true,
        isDelete: false,
        isReset: false,
        isError: false,
      };
    case t.TEMPLATE_SAVE + '_FAIL':
      return {
        ...state,
        isFetch: false,
        isSave: false,
        isError: true,
      };

    case t.TEMPLATE_DELETE + '_REQUEST':
      return {
        ...state,
        isFetch: true,
      };
    case t.TEMPLATE_DELETE + '_RECIEVE':
      return {
        ...state,
        responce: action.data,
        isFetch: false,
        isNew: false,
        isEdit: false,
        isSave: false,
        isDelete: true,
        isReset: false,
        isError: false,
      };
    case t.TEMPLATE_DELETE + '_FAIL':
      return {
        ...state,
        isFetch: false,
        isDelete: false,
        isError: true,
      };
    default:
      return state;
  }
}

export default combineReducers({ templates, template });
