import React from 'react';
import { Route } from 'react-router-dom';
import { moduleAuthorization } from 'modules/authorization/moduleAuthorization';
import TitleChain from 'modules/heading';
import Layout from './containers/Layout';
import Template from './containers/Template';
import { MODULE_NAME } from './constants';

const Auth = moduleAuthorization('settingsAccess.templates')(Layout);

const TemplateAdapter = ({ match, history }) => (
  <Template params={match.params} routeParams={match.params} router={history} />
);

const TemplateRouter = ({ match }) => (
  <Auth>
    <TitleChain>{MODULE_NAME}</TitleChain>
    <Route path={`${match.url}/:id`} component={TemplateAdapter} />
  </Auth>
);

export default TemplateRouter;
