import * as React from 'react';
import Button from '@crm/components/dist/lego2/Button';
import Icon from '@crm/components/dist/lego2/Icon';
import Suggest from 'lego/final-form/Suggest';
import { Field } from 'react-final-form';
import css from './styles.module.css';

interface Props {
  name: string;
  userRoles: Dictionary;
  modules: Dictionary;
  tiers: Dictionary;

  onRemoveClick?: () => void;
}

interface SuggestItem<IdT = string> {
  id: IdT;
  name: string;
}

interface Dictionary {
  items: {
    id: number;
    name: string;
  }[];
}

const SuggestComponent: React.FC<{ item: SuggestItem }> = (props) => {
  return <>{props.item && props.item.name}</>;
};

const getKey = (item: SuggestItem<number>) => {
  return String(item.id);
};

const SuggestField: React.FC<{ name: string; items: SuggestItem<number>[] }> = (outerProps) => {
  return (
    <Field
      name={outerProps.name}
      render={(props) => (
        <Suggest
          {...props}
          getKey={getKey}
          provider={(text: string) => {
            return outerProps.items.filter((item) => item.name.indexOf(text) !== -1);
          }}
          showOnFocus
          className={css.suggest}
          component={SuggestComponent}
        />
      )}
    />
  );
};

class Condition extends React.Component<Props> {
  private handleRemoveClick = (): void => {
    const { onRemoveClick } = this.props;
    if (onRemoveClick) {
      onRemoveClick();
    }
  };

  public render(): React.ReactNode {
    const { name } = this.props;

    return (
      <div className={css.condition}>
        <div className={css.condition__column}>
          <SuggestField name={`${name}.userRoles`} items={this.props.userRoles.items} />
        </div>
        <div className={css.condition__column}>
          <SuggestField name={`${name}.modules`} items={this.props.modules.items} />
        </div>
        <div className={css.condition__column}>
          <SuggestField name={`${name}.tiers`} items={this.props.tiers.items} />
        </div>
        <Button
          className={css.condition__remove}
          view="clear"
          onClick={this.handleRemoveClick}
          icon={(iconCls) => <Icon className={iconCls} type="cross" />}
        />
      </div>
    );
  }
}

export default Condition;
