import React from 'react';
import Avatar from 'components/Avatar';
import { FormattedDate } from 'react-intl';
import WikiFormatter from 'components/WikiFormatter';
import cx from 'classnames';
import FilesList from 'components/FilesList';
import { ArrayPreviewManager } from 'components/PreviewValue/PreviewManager';
import StaffCard from 'components/StaffCard';
import css from './styles.modules.scss';

const Invitees = (props) => {
  const { invitees } = props;

  return (
    Array.isArray(invitees) &&
    Boolean(invitees.length) && (
      <span className={css.invitees}>
        <span className={css.invitees__label}>&nbsp;призвал в комментарии:&nbsp;</span>
        <ArrayPreviewManager value={invitees} />
      </span>
    )
  );
};

const Comment = (props) => {
  const { className, comment, stKey, contentOnly } = props;
  const { dt, text, author, files, invitees, updatedBy } = comment;

  const markdown = text && typeof text === 'object' ? text.text : text;

  const content = (
    <React.Fragment>
      <div className={css.content}>
        <WikiFormatter markdown={markdown} />
        {updatedBy && author && updatedBy.id !== author.id && (
          <div className={css.b__updatedBy}>
            Отредактировал <StaffCard user={updatedBy} theme="yandex" />
          </div>
        )}
      </div>
      <FilesList rootClassName={css.b__files} stKey={stKey} files={files} maxHeight={50} isInline />
    </React.Fragment>
  );

  if (contentOnly) {
    return content;
  }

  return (
    <div className={cx(css.b, className)}>
      <div className={css.avatarColumn}>
        <Avatar user={author} size="xs" theme="round" />
      </div>
      <div className={css.mainColumn}>
        <div className={css.header}>
          <span>
            <StaffCard user={author} theme="yandex" className={css.author} />
            <Invitees invitees={invitees} />
          </span>
          <span className={css.date}>
            <FormattedDate
              value={new Date(dt)}
              year="numeric"
              month="numeric"
              day="numeric"
              hour="numeric"
              minute="numeric"
            />
          </span>
        </div>
        {content}
      </div>
    </div>
  );
};

Comment.Invitees = Invitees;

export default Comment;
