import React, { FC } from 'react';
import PreviewStaff from 'components/PreviewValue/PreviewStaff';
import PreviewValue from 'components/PreviewValue/PreviewValue';
import cx from 'classnames';
import STLink from '../../containers/STLink';
import { HeaderProps } from './Header.types';
import css from './Header.module.css';

const Header: FC<HeaderProps> = props => {
  const { issue, stKey, className } = props;
  const { key, title, assignTo, state } = issue;

  return (
    <div className={cx(className, css.Header)}>
      <div className={css.Header__title}>{title}</div>
      <div>
        <span className={css.Header__group}>
          <STLink stKey={stKey} target="_black">
            {key}
          </STLink>
        </span>
        <span className={css.Header__group}>
          &#8201;
          <span className={css.Header__label}>Статус: </span>
          <PreviewValue value={state} />
        </span>
        <span className={css.Header__group}>
          &#8201;
          <span className={css.Header__label}>Исполнитель: </span>
          <PreviewStaff value={assignTo} theme="yandex" />
        </span>
      </div>
    </div>
  );
};

export default Header;
