/* eslint-disable import/no-named-as-default, import/no-named-as-default-member, react/prop-types */
import React, { Suspense } from 'react';
import PropTypes from 'prop-types';
import NewComment from 'forms/Comment';
import WikiFormatter from 'components/WikiFormatter';
import FilesList from 'components/FilesList';
import Header from '../Header/Header';
import Comment from '../Comment';
import css from './styles.modules.scss';

class Ticket extends React.Component {
  componentDidMount() {
    if (this.props.loadOnMount) {
      this.props.load();
    }
  }

  componentWillUnmount() {
    if (this.props.destroyOnUnmount) {
      this.props.destroy();
    }
  }

  render() {
    if (!this.props.isLoad) {
      return null;
    }

    const {
      stKey,
      data: { issue, comments },
      canComment,
    } = this.props;

    const { key, text, files } = issue;

    return (
      <Suspense fallback={<div />}>
        <div>
          <Header issue={issue} className={css.header} stKey={stKey} />
          <div className={css.info}>
            {text && <WikiFormatter markdown={text} className={css.text} />}
            <FilesList
              rootClassName={css.files}
              stKey={key}
              files={files}
              maxHeight={50}
              isInline
            />
          </div>
          {canComment && (
            <NewComment
              className={css.comment}
              form={`ST/NEW_COMMENT/${key}`}
              onSubmit={this.props.addComment}
            />
          )}
          {Array.isArray(comments) && (
            <div>
              {comments.map(item => (
                <Comment className={css.comment} key={item.id} comment={item} stKey={key} />
              ))}
            </div>
          )}
        </div>
      </Suspense>
    );
  }
}

Ticket.propTypes = {
  loadOnMount: PropTypes.bool,
  canComment: PropTypes.bool,
};

Ticket.defaultProps = {
  loadOnMount: true,
  canComment: false,
};

export default Ticket;
