import React from 'react';
import PropTypes from 'prop-types';
import cx from 'classnames';
import { FormattedDate } from 'react-intl';
import Icon from 'lego/components/Icon';
import css from './styles.modules.scss';
import STLink from '../../containers/STLink';

class Timeline extends React.Component {
  constructor(props) {
    super(props);

    this.state = {
      show: false,
    };
  }

  handleClick = () => {
    this.setState({
      show: !this.state.show,
    });
  };

  handleLinkClick = e => {
    e.stopPropagation();
  };

  render() {
    const {
      classNames,
      theme,
      date,
      startrekIssue: { key, title, state },
      children,
      link,
      id,
      highlight,
    } = this.props;

    const { show } = this.state;

    let view = null;

    if (this.props.view === 'CLIENT_HISTORY') {
      view = css.isCompact;
    }

    return (
      <div className={cx(theme.root, view, { [theme.highlight]: highlight })} id={`timeline${id}`}>
        <div className={theme.header} onClick={this.handleClick}>
          <span className={theme.labels}>
            <span className={theme.label}>
              <Icon size="m" type="svg" icon="startrek" className={theme.icon} />
            </span>
          </span>
          <span className={theme.date}>
            <a tabIndex="0" href={link} className={theme.dateWrap} onClick={this.handleLinkClick}>
              <FormattedDate
                value={new Date(date)}
                year="numeric"
                month="numeric"
                day="numeric"
                hour="numeric"
                minute="numeric"
              />
            </a>
          </span>
          <span className={theme.key}>
            <STLink
              onClick={this.handleLinkClick}
              className={theme.key__link}
              stKey={key}
              target="_blank"
              rel="noopener noreferrer"
            >
              {key}
            </STLink>
          </span>
          <span className={theme.state}>{state}</span>
          <span className={theme.title}>{title}</span>
        </div>
        {show && <div className={theme.content}>{children}</div>}
      </div>
    );
  }
}

Timeline.propTypes = {
  classNames: PropTypes.string,
  theme: PropTypes.objectOf(PropTypes.string),
  highlight: PropTypes.bool,
  link: PropTypes.string,
};

Timeline.defaultProps = {
  classNames: undefined,
  theme: css,
  highlight: false,
  link: undefined,
};

export default Timeline;
