import React, { createElement } from 'react';
import get from 'lodash/get';
import hoistNonReactStatic from 'hoist-non-react-statics';
import { connect } from 'react-redux';
import getDisplayName from 'utils/getDisplayName';
import { baseCallApi } from 'api/common';
import { push } from 'modules/notificationsUI/actions';
import fetchQueue from './fetchQueue';

const filterValues = ({ files, ...other }) => ({
  ...other,
});

function enhanceApi(WrappedComponent) {
  class EnhanceApi extends React.Component {
    constructor(props) {
      super(props);

      this.state = {
        queueList: {
          result: [],
        },
        components: [],
        issyetypes: [],
      };
    }

    componentDidMount() {
      fetchQueue().then((data) => {
        this.setState({ queueList: { ...data, isLoad: true } });
      });

      if (this.props.mailId) {
        baseCallApi({
          url: '/view/startrek/issue/fields/bymail',
          data: {
            mailId: this.props.mailId,
          },
        }).then(({ issue }) => {
          this.setState({
            initialValues: issue,
          });
        });
      }
    }

    render() {
      return createElement(WrappedComponent, {
        ...this.props,
        ...this.state,
        requiredFields: {
          componentIds: get(
            this.state.queueList,
            `entities.queue[${this.props.queue}].componentRequired`,
          ),
        },
      });
    }
  }

  EnhanceApi.displayName = `EnhanceApi(${getDisplayName(WrappedComponent)})`;

  const connector = connect(null, (dispatch, props) => ({
    onSubmit: (values) => {
      const data = {
        ...filterValues(values),
        requestId: props.requestId,
        ticketId: props.ticketId,
        issueId: props.issueId,
      };

      if (props.onSubmit) {
        return props.onSubmit(data);
      }

      return baseCallApi({
        url: '/actions/startrek/issue/create',
        data: {
          ...filterValues(values),
          requestId: props.requestId,
          ticketId: props.ticketId,
          issueId: props.issueId,
        },
        type: 'post',
      });
    },
    onSubmitSuccess: (data) => {
      if (!props.disabledMessages) {
        dispatch(
          push({
            theme: 'success',
            text: `Создан новый тикет ST: ${data.issue.key}`,
          }),
        );
      }
      if (props.onSubmitSuccess) {
        props.onSubmitSuccess();
      }
    },
    dispatch,
  }));

  return hoistNonReactStatic(connector(EnhanceApi), WrappedComponent);
}

export default enhanceApi;
