import { schema, normalize } from 'normalizr';
import { baseCallApi } from 'api/common';

const queueSchema = new schema.Entity('queue', {}, { idAttribute: 'name' });

export default () => baseCallApi({
  url: '/view/startrek/queue/list',
}).then(data => normalize(data.items, [queueSchema]));
