import { createContext as createContextModal } from '@crm/components/dist/lego2/Modal';
import { ModalForm } from 'lego/utils/modalForm';
import modalToReduxFormAdapter from 'lego/hoc/modalToReduxFormAdapter';
import NewTicketForm from './NewTicketForm';

const NewTicketFormModule = createContextModal({ modalProps: { size: 'mid', autoZIndex: true } })(
  modalToReduxFormAdapter(NewTicketForm),
);

export const NewTicketModalForm = new ModalForm(
  'ST_CREATE',
  NewTicketForm,
  { size: 'mid', 'data-testid': 'modal-create-st-ticket' },
  { form: 'ST_CREATE', disabledMessages: true },
);

export default NewTicketFormModule;
