import React from 'react';
import app from 'app';

interface Props extends React.AnchorHTMLAttributes<HTMLAnchorElement> {
  stKey: string;
}

const STLink: React.FC<Props> = props => {
  const { stKey, children, ...other } = props;

  return (
    <a href={app.getStartrekLink(stKey)} {...other}>
      {children}
    </a>
  );
};

export default STLink;
