import * as aTypes from './actionTypes';

export const load = name => ({
  type: 'FETCH',
  args: {
    data: { key: name },
    url: '/view/startrek/issue',
  },
  actions: [aTypes.LOAD_REQUEST, aTypes.LOAD_SUCCESS, aTypes.LOAD_FAIL],
  meta: { name },
});

export const addComment = (name, values) => ({
  type: 'FETCH',
  args: {
    type: 'post',
    data: { key: name, ...values },
    url: '/actions/startrek/issue/comment/add',
  },
  actions: [aTypes.ADD_COMMENT_REQUEST, aTypes.ADD_COMMENT_SUCCESS, aTypes.ADD_COMMENT_FAIL],
  meta: { name },
});
