import bindName from 'utils/bindName';
import bindDispatch from 'utils/bindDispatch';
import { connect } from 'react-redux';
import { load, addComment } from './actions';
import { getTicket } from './selectors';

const mapState = (state, props) => ({
  ...getTicket(state, props.stKey),
});

const mapDispatch = (dispatch, props) => ({
  ...bindDispatch(
    dispatch,
    bindName(
      props.stKey,
      { load, addComment },
    ),
  ),
});

export default WrapComponent => connect(mapState, mapDispatch)(WrapComponent);
