import Immutable from 'immutable';
import * as aTypes from './actionTypes';
import arrayReducerFactory from 'utils/reducer/arrayReducerFactory';

const behaviors = {
  [aTypes.LOAD_REQUEST](state) {
    return state.set('isFetch', true);
  },
  [aTypes.LOAD_SUCCESS](state, { data }) {
    return state.set('isLoad', true).delete('isFetch').set('data', Immutable.fromJS(data));
  },
  [aTypes.LOAD_FAIL](state) {
    return state.delete('isFetch');
  },
  [aTypes.ADD_COMMENT_SUCCESS](state, { data }) {
    return state.updateIn(['data', 'comments'], list => list.insert(0, Immutable.fromJS(data)));
  },
}

export default arrayReducerFactory(aTypes, behaviors);
