import { connect } from 'react-redux';
import { remove } from '../actions';

const mapDispatch = (dispatch, props) => ({
  onRemove: key => dispatch(
    remove(key, { requestId: props.requestId, ticketId: props.ticketId }),
  ).then(
    () => {
      if (props.onChange) {
        props.onChange();
      }
    },
  ),
});

export default WrapComponent => connect(null, mapDispatch)(WrapComponent);
