import { get } from 'api/common';
import * as t from './actionTypes.js';

export const initTags = (name, data) => ({
  type: t.TAGS_INIT,
  data,
  meta: { name },
});

export const updateTags = (name, data) => ({
  type: t.TAGS_UPDATE,
  data,
  meta: { name },
});

export const destroyTags = name => ({
  type: t.TAGS_DESTROY,
  meta: { name },
});

export const addTag = (name, tag) => ({
  type: t.TAG_ADD,
  tag,
  meta: { name },
});

export const deleteTag = (name, tagId) => ({
  type: t.TAG_DELETE,
  tagId,
  meta: { name },
});

export const getTags = data => get({ url: '/view/tag/list', data });
