import { apiCall, baseCallApi } from 'api/common';

const api = {
  get: () => apiCall('/view/account/tag/list'),
  add: (id, tagId) => baseCallApi({
    url: '/actions/account/tag/set',
    type: 'post',
    data: {
      objId: id,
      tagId,
    },
  }),
  remove: (id, tagId) => baseCallApi({
    url: '/actions/account/tag/remove',
    type: 'post',
    data: {
      objId: id,
      tagId,
    },
  }),
};

export default api;
