import memoize from 'lodash/memoize';
import { apiCall, baseCallApi } from 'api/common';

const apiFactory = memoize(objectType => ({
  getTags: () => apiCall('/view/mail/tag/list'),
  addTag: (id, tagId) => baseCallApi({
    url: `/actions/${objectType}/tag/set`,
    type: 'post',
    data: {
      objId: id,
      tagId,
    },
  }),
  removeTag: (id, tagId) => baseCallApi({
    url: `/actions/${objectType}/tag/remove`,
    type: 'post',
    data: {
      objId: id,
      tagId,
    },
  }),
}));

export default apiFactory;
