import { apiCall, baseCallApi } from 'api/common';

const api = {
  get: () => apiCall('/view/mail/tag/list'),
  add: (id, tagId) => baseCallApi({
    url: '/actions/mail/tag/set',
    type: 'post',
    data: {
      objId: id,
      tagId,
    },
  }),
  remove: (id, tagId) => baseCallApi({
    url: '/actions/mail/tag/remove',
    type: 'post',
    data: {
      objId: id,
      tagId,
    },
  }),
};

export default api;
