import React, { FC } from 'react';
import { TagBubble } from 'components/TagBubble';
import css from './MgTag.module.css';
import { MgTagProps } from './MgTag.types';

export const MgTag: FC<MgTagProps> = (props) => {
  const tag = { text: props.name || props.text, color: props.color };
  const deleteHandler = () => {
    props?.onDelete?.(props.id);
  };
  return (
    <TagBubble {...props} className={css.MgTag} tag={tag} onDelete={deleteHandler} canDelete />
  );
};
