/* eslint-disable @typescript-eslint/no-use-before-define */
import React, { useCallback } from 'react';
import PropTypes from 'prop-types';
import Modal from '@crm/components/dist/lego2/Modal';

const NewTagModal = (props) => {
  const { show, onHide, addTag, saveTag, form, initialValues, fields } = props;

  const onSubmitted = useCallback(
    (data, response) => {
      addTag(response.tag);
      onHide();
    },
    [addTag, onHide],
  );

  return (
    <Modal visible={show} onClose={onHide} size="small">
      <ConnectedTagsForm
        form={form}
        fields={fields}
        onSubmit={saveTag}
        onCancel={onHide}
        onSubmitted={onSubmitted}
        initialValues={initialValues}
      />
    </Modal>
  );
};

NewTagModal.propTypes = {
  form: PropTypes.string,
  show: PropTypes.bool,
  initialValues: PropTypes.instanceOf(Object),
  onHide: PropTypes.func,
  addTag: PropTypes.func,
  saveTag: PropTypes.func,
};

NewTagModal.defaultProps = {
  form: undefined,
  show: undefined,
  initialValues: undefined,
  onHide: () => {},
  addTag: () => {},
  saveTag: () => {},
};

export default NewTagModal;

// FIXME: fast fix circular import for storybook
const { ConnectedTagsForm } = require('modules/tags/modules/tagForm');
