import React from 'react';
import PropTypes from 'prop-types';
import Tag from 'lego/components/Tag';
import cx from 'classnames';
import css from './styles.modules.scss';

const TagDefault = props => {
  const { className, color, size, code, isReadOnly, onDelete, tagRef, ...rest } = props;

  return (
    <Tag
      className={cx(className, css.b)}
      size={size}
      color={color}
      onDelete={
        onDelete
          ? () => {
              onDelete(rest.id, { ...rest, code, isReadOnly });
            }
          : undefined
      }
      tagRef={tagRef}
    >
      {rest.name}
    </Tag>
  );
};

TagDefault.propTypes = {
  className: PropTypes.string,
  color: PropTypes.string,
  isReadOnly: PropTypes.bool,
  onDelete: PropTypes.func,
  name: PropTypes.string.isRequired,
  size: PropTypes.string,
  code: PropTypes.string,
  id: PropTypes.number,
  tagRef: PropTypes.instanceOf(Object),
};

TagDefault.defaultProps = {
  className: undefined,
  color: '#ffffff',
  size: 'xs',
  isReadOnly: false,
  onDelete: undefined,
  code: undefined,
  id: undefined,
  tagRef: undefined,
};

export default TagDefault;
