import React from 'react';
import PropTypes from 'prop-types';
import cx from 'classnames';
import createI18N from '@yandex-int/i18n';
import * as keyset from './Tags.i18n';
import Tag from '../Tag';
import defaultTheme from './styles.modules.scss';

const i18nAddTag = createI18N(keyset)('addTag');

const Tags = props => {
  const { className, theme, tagComponent: TagComponent, tags, canEdit, onDelete, size } = props;

  return (
    <span className={cx(className, theme.root)}>
      {!(tags && tags.length)
        ? canEdit && <span className={theme.empty}>{i18nAddTag}</span>
        : tags.map(item => (
          <TagComponent
              key={item.id}
              className={theme.tag}
              onDelete={onDelete}
              size={size}
              {...item}
            />
          ))}
    </span>
  );
};

Tags.propTypes = {
  className: PropTypes.string,
  size: PropTypes.string,
  theme: PropTypes.objectOf(PropTypes.string),
  tagComponent: PropTypes.oneOfType([PropTypes.func, PropTypes.element]),
  tags: PropTypes.arrayOf(PropTypes.instanceOf(Object)),
  canEdit: PropTypes.bool,
  onDelete: PropTypes.func,
};

Tags.defaultProps = {
  className: undefined,
  size: undefined,
  theme: defaultTheme,
  tagComponent: Tag,
  tags: [],
  canEdit: true,
  onDelete: undefined,
};

export default Tags;
