import React from 'react';
import cx from 'classnames';
import { cnTheme } from '@yandex-lego/components/Theme';
import { crmTheme } from '@crm/components/dist/lego2/Theme/presets/themes';
import Tags from '../Tags';
import css from './styles.modules.scss';
import SetTag from '../SetTag';
import apiMail from '../../api/mail';
import Tag from '../Tag';
import WithAuthorTag from '../../containers/WithAuthorTag';

const getTags = () => apiMail.get();

class TagsWithAdd extends React.Component {
  static defaultProps = {
    onLoad: getTags,
  };

  handleAdd = (tag) => {
    if (this.props.onAdd) {
      this.props.onAdd(tag.id, tag);
    }
  };

  render() {
    const {
      className,
      canEdit,
      onLoad,
      onRemove,
      onAdd,
      tagsClassName,
      canCreate,
      placement,
      addClassName,
      tags,
      showAuthor,
      ...passThroughProps
    } = this.props;

    return (
      <div className={cx(css.root, className, cnTheme({ root: crmTheme.root }))}>
        {canEdit && onLoad && (
          <SetTag
            className={addClassName}
            loadTags={onLoad}
            addTag={this.handleAdd}
            placement={placement}
            canCreate={canCreate}
          />
        )}
        <Tags
          className={tagsClassName}
          canEdit={canEdit}
          onDelete={canEdit ? onRemove : undefined}
          tags={tags}
          tagComponent={showAuthor ? WithAuthorTag : Tag}
          {...passThroughProps}
        />
      </div>
    );
  }
}

export default TagsWithAdd;
