import React, { FC } from 'react';
import Tag from 'modules/tags/components/Tag';
import cx from 'classnames';
import { MgTag } from 'modules/tags/components/MgTag';
import TagAuthor from 'modules/tags/containers/WithAuthorTag';
import MgTagAuthor from 'modules/tags/containers/WithAuthorMgTag';
import OptimizedTags from 'modules/tags/containers/OptimizedTags';
import { eTypeToApi } from './TimelineItemTags.config';
import { TimelineItemTagsProps } from './TimelineItemTags.types';
import css from './TimelineItemTags.module.css';

export const TimelineItemTags: FC<TimelineItemTagsProps> = (props) => {
  const {
    className,
    size,
    name,
    id,
    tags,
    canEdit,
    destroyOnUnmount,
    withRedux = true,
    asyncInit,
    needInit,
    newTheme = true,
    eType = 'Mail',
  } = props;

  if (!name) return null;

  let tagComponent = id ? TagAuthor : Tag;
  if (newTheme) {
    tagComponent = id ? MgTagAuthor : MgTag;
  }

  const apiTags = eTypeToApi[eType] || eTypeToApi.Mail;

  return (
    <OptimizedTags
      className={cx(css.TimelineItemTags, className)}
      addClassName={css.TimelineItemTags__addButton}
      size={size}
      name={name}
      getTags={() => apiTags.get()}
      addTag={id ? (tagId) => apiTags.add(id, tagId) : undefined}
      removeTag={id ? (tagId) => apiTags.remove(id, tagId) : undefined}
      tags={tags}
      canEdit={canEdit}
      tagComponent={tagComponent}
      destroyOnUnmount={destroyOnUnmount}
      asyncInit={asyncInit}
      needInit={needInit}
      withRedux={withRedux}
      enableReinitialize
    />
  );
};
