import { createElement, Component } from 'react';
import PropTypes from 'prop-types';
import getDisplayName from 'utils/getDisplayName';
import apiFactory from '../api/apiFactory';

export default config => WrappedComponent => {
  class WithApi extends Component {
    constructor(props) {
      super(props);

      this.apiProps = apiFactory(props.objectType);
    }

    handleAddTag = tagId => this.apiProps.addTag(this.props.objectId, tagId);
    handleRemoveTag = tagId => this.apiProps.removeTag(this.props.objectId, tagId);

    render() {
      const { objectType, objectId, ...passPropsThrough } = this.props;

      const props = {
        ...passPropsThrough,
        ...this.apiProps,
        removeTag: this.handleRemoveTag,
        addTag: this.handleAddTag,
        name: `${objectType}/${objectId}`,
      };

      return createElement(WrappedComponent, props);
    }
  }

  WithApi.propTypes = {
    objectType: PropTypes.string.isRequired,
    objectId: PropTypes.number.isRequired,
  };

  WithApi.defaultProps = {
    ...config,
  };

  WithApi.displayName = `WithApi(${getDisplayName(WrappedComponent)})`;

  return WithApi;
};
