import { createElement, Component } from 'react';
import getDisplayName from 'utils/getDisplayName';

export default () => (Fast, Slow) => {
  const MAP = {
    false: Fast,
    true: Slow,
  };

  class WithSwitch extends Component {
    static getDerivedStateFromProps(props, state) {
      if (!state.withRedux && props.withRedux) {
        return { withRedux: true };
      }

      return null;
    }

    constructor(props) {
      super(props);

      this.state = {
        withRedux: props.withRedux,
      };
    }

    render() {
      return createElement(MAP[this.state.withRedux], this.props);
    }
  }

  WithSwitch.displayName = `WithSwitch(${getDisplayName(Slow)})`;

  return WithSwitch;
};
