import React, { Component } from 'react';
import ToolTip from 'lego/components/ToolTip';
import { FormattedDate } from 'react-intl';
import css from './styles.modules.scss';

const withAuthor = (WrappedComponent) => {
  class TagWithAuthor extends Component {
    render() {
      const { date, userName, ...passThroughProps } = this.props;

      const popup = (
        <div className={css.root}>
          <div className={css.author}>
            {userName}
          </div>
          <div className={css.date}>
            <FormattedDate
              value={date}
              day="numeric"
              month="long"
              year="numeric"
            />
          </div>
        </div>
      );

      return (
        <ToolTip
          tooltip={popup}
        >
          <WrappedComponent
            {...passThroughProps}
          />
        </ToolTip>
      );
    }
  }

  return TagWithAuthor;
};

export default withAuthor;
