import React, { Component } from 'react';
import PropTypes from 'prop-types';
import { connect } from 'react-redux';
import cx from 'classnames';
import { cnTheme } from '@yandex-lego/components/Theme';
import { crmTheme } from '@crm/components/dist/lego2/Theme/presets/themes';
import * as actions from '../../actions';
import SetTag from '../../components/SetTag/index';
import css from './styles.modules.scss';

const withField = (WrappedComponent) => {
  class TagsWithField extends Component {
    // TODO: refactoring
    // поддержал пока тут и final-form и redux-form
    // теги нужно отревачить, все смешалось тут
    getValue = () => {
      const { fields, value, useValue } = this.props;

      return useValue ? value : fields.getAll();
    };

    add = (tag) => {
      const { fields, addTag } = this.props;
      const value = this.getValue();

      const hasTag =
        value &&
        value.some((item, i) => {
          if (item.id === tag.id) {
            fields.move(i, 0);
          }
          return item.id === tag.id;
        });

      if (!hasTag) {
        fields.insert(0, tag);
      }

      if (typeof addTag === 'function') {
        addTag(tag.id).then((response) => {
          if (response.success) {
            this.props.add(tag);
          }

          return response;
        });
      }
    };

    delete = (id) => {
      const { fields, removeTag } = this.props;
      const value = this.getValue();

      if (value) {
        value.some((item, i) => {
          if (item.id === id) {
            fields.remove(i);
          }
          return item.id === id;
        });
      }

      if (typeof removeTag === 'function') {
        removeTag(id).then((response) => {
          if (response.success) {
            this.props.delete(id);
          }

          return response;
        });
      }
    };

    render() {
      const {
        className,
        addClassName,
        tagsClassName,
        getTags,
        addTag,
        removeTag,
        fields,
        type,
        formFields,
        useValue,
        ...passThroughProps
      } = this.props;

      const value = this.getValue() || [];

      return (
        <div className={cx(css.root, className, cnTheme({ root: crmTheme.root }))}>
          <SetTag
            className={addClassName}
            type={type}
            formFields={formFields}
            loadTags={getTags}
            addTag={this.add}
          />
          <WrappedComponent
            className={tagsClassName}
            onDelete={this.delete}
            tags={value}
            {...passThroughProps}
          />
        </div>
      );
    }
  }

  TagsWithField.propTypes = {
    useValue: PropTypes.boolean,
    className: PropTypes.string,
    addClassName: PropTypes.string,
    tagsClassName: PropTypes.string,
    getTags: PropTypes.func,
    addTag: PropTypes.func,
    removeTag: PropTypes.func,
    fields: PropTypes.instanceOf(Object).isRequired,
    add: PropTypes.func,
    delete: PropTypes.func,
  };

  TagsWithField.defaultProps = {
    useValue: false,
    className: undefined,
    addClassName: undefined,
    tagsClassName: undefined,
    getTags: undefined,
    addTag: undefined,
    removeTag: undefined,
    add: () => {},
    delete: () => {},
  };

  const mapDispatch = (dispatch, props) => {
    const { name } = props;

    if (!name) return {};

    const bindName = (actionCreator) => actionCreator.bind(null, name);

    return {
      add: (tag) => dispatch(bindName(actions.addTag)(tag)),
      delete: (tagId) => dispatch(bindName(actions.deleteTag)(tagId)),
    };
  };

  return connect(null, mapDispatch)(TagsWithField);
};

export default withField;
