import { connect } from 'react-redux';
import { isValid, submit } from 'redux-form'

const mapState = (state, props) => {
  const formName = props.form;

  return {
    isValid: isValid(formName)(state),
  };
};

const mapDispatch = (dispatch, props) => {
  const formName = props.form;

  return {
    saveTag: () => dispatch(submit(formName)),
  };
};

export default WrappedComponent => connect(mapState, mapDispatch)(WrappedComponent);
