import WithManage from './containers/WithManage';
import WithApi from './components/WithApi';
import Tags from './components/Tags';
import Tag from './components/Tag';
import { TagsField } from './components/TagsField';
import { TimelineItemTags } from './components/TimelineItemTags';
import TagAuthor from './containers/WithAuthorTag';
import TagsWithAdd from './components/TagsWithAdd';
import withSwitch from './components/withSwitch';
import apiMail from './api/mail';
import apiAccount from './api/account';

export { NAME } from './constants';
export { initTags, destroyTags, updateTags, addTag, deleteTag } from './actions';

export const TagsManage = WithManage(Tags);
export const TagsWithApi = WithApi()(TagsManage);
export const OptimizedTags = withSwitch()(Tags, TagsManage);
export const OptimizedTagsWithApi = withSwitch()(Tags, TagsWithApi);

//import 'modules/tags/components/TagsField' - Быстрый фикс
// TODO: https://st.yandex-team.ru/CRM-11158
export { Tags, Tag, TagAuthor, TagsWithAdd, apiMail, apiAccount, TagsField, TimelineItemTags };
