import { jsonApiCall } from 'api/common';
import TYPES from 'constants/backendTypesRaw';
import * as t from './actionTypes.js';

const TAG_POST_REQUEST = `${t.TAG_SAVE}_REQUEST`;
const TAG_POST_RECIEVE = `${t.TAG_SAVE}_RECIEVE`;
const TAG_POST_FAIL = `${t.TAG_SAVE}_FAIL`;
export const saveTag = (data = {}) => {
  let sendData = data;
  if (!data.type) {
    sendData = { ...data };
    sendData.type = TYPES.TYPES.MAIL;
  }

  return {
    type: 'PROMISE',
    actions: [TAG_POST_REQUEST, TAG_POST_RECIEVE, TAG_POST_FAIL],
    promise: jsonApiCall({
      url: '/actions/tag/save',
      data: sendData,
    }),
  };
};
