import React from 'react';
import PropTypes from 'prop-types';
import Button from '@crm/components/dist/lego2/Button';
import { SuggestStaffInline2 as Suggest } from 'lego/components/SuggestStaff';
import createI18N from '@yandex-int/i18n';
import * as commonKeyset from 'common.i18n';
import Row from 'forms/Base/Row';
import Form from 'components/Form';
import * as keyset from './Form.i18n';
import { PseudoField } from '../PseudoField';

const commonI18n = createI18N(commonKeyset);
const i18n = createI18N(keyset);
const i18nEditTag = i18n('editTag');
const i18nNewTag = i18n('newTag');
const i18nTagName = i18n('tagName');
const i18nGrants = i18n('grants');
const i18nTagColor = i18n('tagColor');
const i18nArchived = i18n('archived');
const i18nSave = commonI18n('save');
const i18nCancel = commonI18n('cancel');

class TagForm extends React.Component {
  handleSubmit = (e) => {
    const { handleSubmit } = this.props;

    // так как форма создания заметки может находиться в другой форме, например, форме звонка,
    // нужно блокировать всплытие события, чтобы не было ошибки
    e.stopPropagation();
    return handleSubmit(e);
  };

  render() {
    const { submitting, invalid, id, onCancel, fields } = this.props;

    return (
      <Form onSubmit={this.handleSubmit}>
        <Form.Header>{id ? i18nEditTag : i18nNewTag}</Form.Header>
        <Form.Body>
          {id && <PseudoField label="ID метки">{id}</PseudoField>}
          {fields.name && (
            <Row
              label={i18nTagName}
              component="TextInput"
              name="name"
              required={fields.name.required}
            />
          )}
          {fields.grants && (
            <Row
              label={i18nGrants}
              component="SuggestStaffInline2"
              variant={Suggest.StaffSuggestVariant.All}
              onlyUserActive
              name="grants"
              isNew={!id}
              required={fields.grants.required}
            />
          )}
          {fields.color && (
            <Row
              label={i18nTagColor}
              component="ColorPicker"
              name="color"
              required={fields.color.required}
            />
          )}
          {fields.isArchived && <Row label={i18nArchived} component="CheckBox" name="isArchived" />}
        </Form.Body>
        <Form.Footer>
          <Button type="submit" view="action" disabled={submitting || invalid}>
            {i18nSave}
          </Button>
          <Button disabled={submitting} onClick={onCancel}>
            {i18nCancel}
          </Button>
        </Form.Footer>
      </Form>
    );
  }
}

TagForm.propTypes = {
  id: PropTypes.number,
  name: PropTypes.string,
  onCancel: PropTypes.func,
  handleSubmit: PropTypes.func.isRequired,
  submitting: PropTypes.bool.isRequired,
  invalid: PropTypes.bool.isRequired,
  fields: PropTypes.instanceOf(Object).isRequired,
};

TagForm.defaultProps = {
  id: undefined,
  name: undefined,
  onCancel: undefined,
};

export default TagForm;
