import { connect } from 'react-redux';
import { reduxForm, formValueSelector } from 'redux-form';
import { toGrantAdapter } from 'lego/components/SuggestStaff';
import GrantsModel from 'lego/components/Grants/model';
import get from 'lodash/get';
import * as actions from '../actions';

const validate = (values, { fields }) => {
  const errors = {};
  let requiredFields;
  if (fields) {
    requiredFields = Object.keys(fields).filter(key => fields[key].required);
  }

  requiredFields.forEach(field => {
    const valueIsEmptyArray = Array.isArray(values[field]) && !values[field].length;
    if (field === 'grand' && !GrantsModel.validate(values.grants)) {
      errors.grants = { _error: 'Обязательно для заполнения' };
    } else if (!values[field] || valueIsEmptyArray) {
      errors[field] = 'Обязательно для заполнения';
    }
  });

  return errors;
};

const mapState = (state, props) => {
  const formName = props.form;
  const selector = formValueSelector(formName);
  const { id, name } = selector(state, 'id', 'name');

  return {
    id,
    name,
  };
};

const mapDispatch = (dispatch, props) => ({
  onSubmit: data => {
    const tag = Object.assign({}, data);

    tag.tagId = tag.id;
    delete tag.id;
    if (props.fields && props.fields.grants) {
      const grants = (tag.grants || []).map(toGrantAdapter);
      const initialGrants = (get(props, 'initialValues.grants') || []).map(toGrantAdapter);
      tag.grants = GrantsModel.formatToBackend(grants, initialGrants);
    }

    return dispatch(actions.saveTag(tag)).then(response => {
      if (response.success === true && typeof props.onSubmitted === 'function') {
        props.onSubmitted(data, response);
      }

      return response;
    });
  },
});

export default WrappedComponent => {
  const Component = connect(
    mapState,
    mapDispatch,
  )(reduxForm({ validate })(WrappedComponent));

  Component.defaultProps = {
    fields: {
      name: {
        required: true,
      },
      grants: {
        required: true,
      },
      color: {
        required: true,
      },
      isArchived: {
        required: false,
      },
    },
  };

  return Component;
};
