import * as t from './actionTypes';

const tag = (state = {}, action) => {
  switch (action.type) {
    case `${t.TAG_SAVE}_REQUEST`:
      return {
        ...state,
        isFetch: true,
      };
    case `${t.TAG_SAVE}_RECIEVE`:
      return {
        ...state,
        response: action.data,
        isFetch: false,
        isNew: false,
        isEdit: false,
        isSave: true,
        isDelete: false,
        isError: false,
      };
    case `${t.TAG_SAVE}_FAIL`:
      return {
        ...state,
        isFetch: false,
        isError: true,
      };
    default:
      return state;
  }
};

export default tag;
