import { NAME } from './constants';
import * as t from './actionTypes';

const TAG_INIT = {
  mount: 0,
};

const tags = (state = TAG_INIT, action) => {
  switch (action.type) {
    case t.TAGS_INIT:
      return {
        ...state,
        data: action.data || [],
        isSet: true,
        mount: state.mount + 1,
      };
    case t.TAGS_DESTROY: {
      const mount = state.mount - 1;
      if (mount) {
        return {
          ...state,
          mount,
        };
      }

      return undefined;
    }
    case t.TAGS_UPDATE:
      return {
        ...state,
        data: action.data || [],
        isUpdated: true,
      };
    case t.TAG_ADD: {
      const dataAdded = [...state.data];
      dataAdded.some((item, i, arr) => {
        if (item.id === action.tag.id) {
          arr.splice(i, 1);
        }
        return item.id === action.tag.id;
      });
      dataAdded.unshift(action.tag);

      return {
        ...state,
        data: dataAdded,
        isAdd: true,
        isDelete: false,
      };
    }
    case t.TAG_DELETE: {
      const dataDeleted = [...state.data];
      dataDeleted.some((item, i, arr) => {
        if (item.id === action.tagId) {
          arr.splice(i, 1);
        }
        return item.id === action.tagId;
      });

      return {
        ...state,
        data: dataDeleted,
        isAdd: false,
        isDelete: true,
      };
    }
    default:
      return state;
  }
};

const tagsReducer = (state = {}, action) => {
  const { meta, ...other } = action;

  if (meta && meta.name && other.type.startsWith(NAME)) {
    return {
      ...state,
      [meta.name]: tags(state[meta.name], other),
    };
  }

  return state;
};

export default tagsReducer;
