import React from 'react';
import Textinput from '@crm/components/dist/lego2/Textinput';
import WordBreak from 'components/WordBreak';
import Menu from '@crm/components/dist/lego2/Menu';
import createI18N from '@yandex-int/i18n';
import FilesList from 'components/FilesList';
import * as keyset from './Templates.i18n';
import css from './styles.module.css';
import getFilteredGroups from './getFilteredGroups';
import TemplatesListItem from './TemplatesListItem';

const i18n = createI18N(keyset);
const i18nFiles = i18n('files');
const i18nTemplateSearch = i18n('templateSearch');

class TemplatesList extends React.Component {
  constructor(props) {
    super(props);

    this.templates = [];

    this.state = {
      item: null,
      searchText: '',
      groups: getFilteredGroups(props.templates, null, props.isPlain()),
    };
  }

  componentWillReceiveProps(nextProps) {
    if (nextProps.templates !== this.props.templates) {
      this.setState({
        groups: getFilteredGroups(nextProps.templates, this.state.searchText, this.props.isPlain()),
      });
    }
  }

  onSearchChange = (value) => {
    this.setState({
      searchText: value,
      groups: getFilteredGroups(this.props.templates, value, this.props.isPlain()),
    });
  };

  onTemplateMouseEnter = (item) => {
    this.setState({ item });
  };

  setTemplate = (menuEvent) => {
    const templateId = menuEvent.target.value;
    const template = this.templates.find((value) => value.templateId === templateId);
    this.props.onTemplateClick(template);
  };

  renderTemplates() {
    const { groups } = this.state;

    if (!groups) {
      return null;
    }

    const selectedId = this.state.item && this.state.item.templateId;
    this.groupsWithTemplates = groups.filter((group) => group && group.list.length);
    this.templates = this.groupsWithTemplates.reduce((acc, group) => acc.concat(group.list), []);
    const items = this.groupsWithTemplates.map((group) => ({
      title: group.name,
      items: group.list.map((template) => ({
        value: template.templateId,
        content: (
          <TemplatesListItem
            template={template}
            onMouseEnter={() => this.onTemplateMouseEnter(template)}
          />
        ),
      })),
    }));

    return <Menu value={selectedId} items={items} onChange={this.setTemplate} />;
  }

  render() {
    return (
      <div className={css.templatesForm} onKeyUp={this.props.onKeyUp} role="presentation">
        <WordBreak className={css.preview}>
          {this.state.item && (
            <div dangerouslySetInnerHTML={{ __html: this.state.item.bodyPreview }} />
          )}
          {this.state.item && this.state.item.files && Boolean(this.state.item.files.length) && (
            <div>
              <div className={css.preview__title}>{i18nFiles}</div>
              <FilesList files={this.state.item.files} />
            </div>
          )}
        </WordBreak>
        <div className={css.list}>
          <Textinput
            className={css.search}
            placeholder={i18nTemplateSearch}
            size="s"
            value={this.state.searchText}
            onChange={this.onSearchChange}
            pin="brick-brick"
            autoFocus
          />
          <div className={css.templates}>{this.renderTemplates()}</div>
        </div>
      </div>
    );
  }
}

export default TemplatesList;
