import React, { PureComponent } from 'react';
import PropTypes from 'prop-types';
import css from './styles.module.css';

export default class TemplatesListItem extends PureComponent {
  render() {
    const {
      template: { namePreview },
    } = this.props;

    return (
      <>
        <span className={css.templateOverlay} onMouseEnter={this.props.onMouseEnter} />
        <span dangerouslySetInnerHTML={{ __html: namePreview }} />
      </>
    );
  }
}

TemplatesListItem.propTypes = {
  onMouseEnter: PropTypes.func.isRequired,
  template: PropTypes.shape({
    templateId: PropTypes.number.isRequired,
    namePreview: PropTypes.string.isRequired,
  }).isRequired,
};
