import escapeRegExp from 'lodash/escapeRegExp';
import css from './styles.module.css';

const getBodyPreview = (template, isPlain = false) => {
  if (isPlain) {
    return `<div class="${css.preview__title}">${template.name}</div><pre>${template.bodyPlain}</pre>`;
  }

  return `<div class="${css.preview__title}">${template.name}</div>${template.bodyHtml}`;
};

const filterTemplates = (tempaltes = [], searchStr = '', isPlain = false) => {
  if (!tempaltes.length) {
    return tempaltes;
  }

  if (!searchStr) {
    return tempaltes.map(template => ({
      ...template,
      bodyPreview: getBodyPreview(template, isPlain),
      namePreview: template.name,
    }));
  }

  const searchStrLower = escapeRegExp(searchStr.toLowerCase());
  const filteredList = [];
  const searchPattern = new RegExp(`(${searchStrLower})`, 'gim');

  for (let i = 0; i < tempaltes.length; i += 1) {
    const template = tempaltes[i];
    let bodyPreview = getBodyPreview(template, isPlain);

    if (bodyPreview.toLowerCase().indexOf(searchStrLower) !== -1) {
      bodyPreview = bodyPreview.replace(
        searchPattern,
        match => `<span style="background-color: yellow;">${match}</span>`,
      );

      const namePreview = template.name.replace(
        searchPattern,
        match => `<span style="background-color: yellow;">${match}</span>`,
      );

      filteredList.push({ ...template, bodyPreview, namePreview });
    }
  }

  return filteredList;
};

export default filterTemplates;
