import filterTemplates from './filterTemplates';

export default (templates, searchText, isPlain) => {
  if (!Array.isArray(templates)) {
    return null;
  }

  const groups = [];
  let currentGroup;
  let currentType;
  filterTemplates(templates, searchText, isPlain).forEach(template => {
    if (template.type !== currentType) {
      const newGroup = {
        name: template.typeName,
        list: [template],
      };

      groups.push(newGroup);
      currentGroup = newGroup;
      currentType = template.type;
    } else {
      currentGroup.list.push(template);
    }
  });

  return groups;
};
