import { connect } from 'react-redux';
import flowRight from 'lodash/flowRight';
import { bindActionCreators } from 'redux';
import bindName from 'utils/bindName';
import loader from 'hoc/loader';
import destroyDriver from 'utils/destroyDriver';
import injectReducerHoc from 'utils/injectReducerHoc';
import { NAME } from '../constants';
import reducers from '../reducer';
import * as actions from '../actions';
import { getState } from '../selectors';

const mapState = (state, props) => ({
  ...getState(props.name)(state),
});

const mapDispatch = (dispatch, props) => ({
  ...bindActionCreators(bindName(props.name, actions), dispatch),
});

const loaderConfig = {
  onMount(props) {
    if (!props.isLoad) {
      props.load(props.provider);
    }
  },
  onUnmount(props) {
    if (props.destroyOnUnmount) {
      props.destroy();
    }
  },
};

const connectorTemplates = config => (WrappedComponent) => {
  return flowRight(
    injectReducerHoc({ name: NAME, reducers }),
    connect(mapState, mapDispatch),
    destroyDriver({ slugName: 'name' }),
    loader(loaderConfig),
  )(WrappedComponent);
};

export default connectorTemplates;
