import arrayReducerFactoryRaw from 'utils/reducer/arrayReducerFactoryRaw';
import * as aTypes from './actionTypes';

const INIT_STATE = {};

const behaviors = {
  [aTypes.LOAD_REQUEST](state) {
    return { ...state, isFetch: true };
  },
  [aTypes.LOAD_RECEIVE](state, { data }) {
    return { ...state, isFetch: false, isLoad: true, ...data };
  },
  [aTypes.LOAD_FAIL](state) {
    return { ...state, isFetch: false };
  },
  [aTypes.DESTROY]() {
    return undefined;
  },
};

export default arrayReducerFactoryRaw(aTypes, behaviors, INIT_STATE);
