import { isToday } from 'date-fns';
import { IntlShape } from 'react-intl';

export const formatTimelineDate = (
  date: string,
  formatDate: IntlShape['formatDate'],
  todayString: string = 'Сегодня',
): string => {
  const formattedDate = formatDate(date, {
    month: 'long',
    weekday: 'long',
    day: 'numeric',
  });

  const datePresentation = new Date(date);

  if (isToday(datePresentation)) {
    return todayString;
  }

  const dateYear = datePresentation.getFullYear();
  const currentYear = new Date().getFullYear();

  return dateYear !== currentYear ? `${formattedDate} ${dateYear}` : formattedDate;
};
