import { ModuleName } from 'modules/issues/types';

export const TicketModule = ModuleName.Ticket;
export const IssuesModule = ModuleName.Issue;
export const OpportunitiesModule = ModuleName.Opportunities;
export const FormName = 'timer';
export const DEFAULT_KEY = 'ticket';
export const DEFAULT_EXECUTOR_OPTION = 2;

export default {
  ru: {
    create: {
      title: 'Создать новый таймер',
      ok: 'Создать',
    },
    edit: {
      title: 'Редактирование таймера',
      ok: 'Сохранить',
    },
  },
  fields: {
    map: {
      startDate: {
        name: 'startDate',
        label: 'Дата',
        component: 'Date',
        time: true,
        fastValues: true,
        initOnMount: true,
        initOffset: {
          days: 1,
        },
        minDate: 'auto',
        autoFocus: true,
        props: { view: 'inline' },
      },
      action: {
        name: 'action',
        label: 'Назначить',
        component: 'Select',
        mode: 'radio',
        options: [
          { value: '2', content: 'На последнего исполнителя' },
          { value: '3', content: 'В очередь' },
        ],
      },
      users: {
        name: 'users',
        label: 'Уведомить',
        component: 'SuggestStaffInline2',
        size: 'm',
        variant: 'UsersOnly',
        onlyUserHadAnyRole: true,
      },
      comment: {
        name: 'comment',
        label: 'Комментарий',
        component: 'TextArea',
        size: 'm',
        max: 256,
      },
    },
    list: ['startDate', 'action', 'users', 'comment'],
  },
  forms: {
    [IssuesModule]: {
      showHint: true,
      startDate: {
        required: true,
      },
      users: {
        required: true,
      },
      comment: {},
    },
    [OpportunitiesModule]: {
      showHint: true,
      startDate: {
        required: true,
      },
      users: {
        required: true,
      },
      comment: {},
    },
    ticket: {
      showHint: true,
      startDate: {
        required: true,
      },
      action: {
        required: true,
      },
    },
    [TicketModule]: {
      startDate: {
        required: false,
      },
      action: {
        props: {
          mode: 'radiocheck',
          isSingleValue: true,
          isNullEmptyValue: true,
        },
      },
      showHint: false,
      users: {},
      comment: {
        props: {},
      },
    },
  },
};
