import React, { ComponentType } from 'react';
import { formValueSelector, reduxForm } from 'redux-form';
import { connect } from 'react-redux';
import get from 'lodash/get';
import { ModuleName } from 'modules/issues/types';
import { FormName, TicketModule } from './Form.config';
import { validate } from './helpers';
import { TimerForm } from './Form';
import { MergedTimerFormProps, Store, TimerFormProps, ConnectedStateProps } from './Form.types';
import { withSaveValues } from './withSaveValues.hoc';

const selector = formValueSelector(FormName);

const mapStateToProps = (state: Store, ownProps: TimerFormProps): ConnectedStateProps => {
  const allUsers = selector(state, 'users');

  return {
    currentUser: get(state, 'root.info.user'),
    isCommentHidden: !(Array.isArray(allUsers) && allUsers.length),
    onSubmit: (values): void => {
      if (ownProps.module === TicketModule) {
        const submitValues = { ...values, comment: undefined };
        const { users } = submitValues;
        if (users != null) {
          submitValues.comment = values.comment;
        }
        return ownProps.onSubmit(submitValues);
      }

      return ownProps.onSubmit(values);
    },
  };
};

/* Fast fix for https://st.yandex-team.ru/CRM-10111 */

export const ReduxFormComponent = reduxForm({ validate })(TimerForm);

const DefaultForm = connect(mapStateToProps)(ReduxFormComponent);

const WithSaveValuesForm = connect(mapStateToProps)(
  withSaveValues((ReduxFormComponent as unknown) as ComponentType<MergedTimerFormProps>),
);

interface SwitcherFormProps {
  module: string;
}

const SwitcherForm: React.FC<SwitcherFormProps> = props => {
  if (props.module === ModuleName.Ticket) {
    return React.createElement(WithSaveValuesForm, props as MergedTimerFormProps);
  }

  return React.createElement(DefaultForm, props as TimerFormProps);
};

export default SwitcherForm;
