import React, { PureComponent, ReactNode } from 'react';

import { Row, Form } from 'forms/Base';

import config, { DEFAULT_KEY } from './Form.config';
import FormFooter from './FormFooter';

import { MergedTimerFormProps } from './Form.types';

export class TimerForm extends PureComponent<MergedTimerFormProps> {
  public render(): ReactNode {
    const {
      handleSubmit,
      pristine,
      submitting,
      valid,
      isNew,
      onCancel,
      formType = DEFAULT_KEY,
      module,
      isCommentHidden,
    } = this.props;

    const isValid = !pristine && !submitting && valid;

    const str = isNew ? config.ru.create : config.ru.edit;
    const formConfig = config.forms[module || formType];

    return (
      <Form onSubmit={handleSubmit} title={str.title} hint={formConfig.showHint} theme="modal">
        {config.fields.list.map((key) => {
          if (!formConfig[key]) {
            return false;
          }

          if (key === 'comment' && isCommentHidden) {
            return null;
          }

          const componentProps = formConfig[key].props || {};

          return (
            <Row
              key={key}
              {...config.fields.map[key]}
              {...componentProps}
              required={formConfig[key].required}
            />
          );
        })}
        <FormFooter isValid={isValid} onCancel={onCancel} str={str} />
      </Form>
    );
  }
}
