import { InjectedFormProps, SubmitHandler } from 'redux-form';

export interface User {
  id: number;
  name: string;
  login: string;
  position: string;
  mainRole: string;
  mainRoleName?: string;
  isAdmin: boolean;
  isSupport: boolean;
  isTeamlead: boolean;
  isGrouplead: boolean;
}

export interface Store {
  root: {
    info: {
      user: User;
    };
  };
}

export interface ConnectedStateProps {
  isCommentHidden: boolean;
  currentUser: User;
  onSubmit: SubmitHandler;
}

export interface TimerFormProps {
  isNew: boolean;
  onCancel: () => void;
  onSubmit: SubmitHandler;
  formType: string;
  module: string;
}

export type MergedTimerFormProps = TimerFormProps &
  ConnectedStateProps &
  InjectedFormProps<{}, TimerFormProps>;
