import React, { PureComponent } from 'react';
import { Footer } from 'forms/Base';
import Button from '@crm/components/dist/lego2/Button';
import Toolbar from 'components/Toolbar';
import { FormFooterProps } from './FormFooter.types';

export default class FormFooter extends PureComponent<FormFooterProps> {
  public render() {
    const { isValid, str, onCancel } = this.props;

    return (
      <Footer buttons={false}>
        <Toolbar reverse>
          <Button type="submit" view="action" size="m" disabled={!isValid}>
            {str.ok}
          </Button>
          <Button size="m" onClick={onCancel}>
            Отменить
          </Button>
        </Toolbar>
      </Footer>
    );
  }
}
