// @ts-ignore
import errorMessages from 'requestForms/BaseForm/errors';
import config, { DEFAULT_KEY, TicketModule } from './Form.config';
import { TimerFormProps } from './Form.types';

interface Errors {
  [k: string]: string;
}

export const validate = (values, props: TimerFormProps): Errors => {
  const errors: Errors = {};
  const type = props.module || props.formType || DEFAULT_KEY;
  const formConfig = config.forms[type];

  const requiredFields = Object.keys(formConfig).filter(
    (key) => formConfig[key] && formConfig[key].required,
  );

  requiredFields.forEach((field) => {
    if (values[field] == null) {
      errors[field] = errorMessages.required;
    }
  });

  const isActionInvalid =
    values.action == null || (Array.isArray(values.action) && !values.action.length);
  if (type === TicketModule) {
    if (values.users == null && isActionInvalid) {
      const msg = 'Должны быть заполнены либо users, либо action';
      errors.users = msg;
      errors.action = msg;
    }
  }

  return errors;
};
