import React, { Component, ComponentType } from 'react';
import { MergedTimerFormProps } from './Form.types';
import { DEFAULT_EXECUTOR_OPTION } from './Form.config';

export const withSaveValues = <P extends MergedTimerFormProps>(
  WC: ComponentType<P>,
): ComponentType<P> =>
  class extends Component<P> {
    private getStorageKey = (): string => {
      const { currentUser } = this.props;
      return `space.user_id_${currentUser.id}.last_assign_timer_option`;
    };

    private onSubmit = (values): void => {
      this.props.onSubmit(values);
      const { action } = values;
      localStorage.setItem(this.getStorageKey(), JSON.stringify(action || ''));
    };

    private getLastAssignAction = (): number => {
      try {
        const action = localStorage.getItem(this.getStorageKey());
        return action ? JSON.parse(action) : DEFAULT_EXECUTOR_OPTION;
      } catch (e) {
        return DEFAULT_EXECUTOR_OPTION;
      }
    };

    public render() {
      let { initialValues } = this.props;
      const lastAction = this.getLastAssignAction();
      if (lastAction) {
        initialValues = { ...initialValues, action: lastAction };
      }

      return <WC {...this.props} onSubmit={this.onSubmit} initialValues={initialValues} />;
    }
  };
